/*
 * Decompiled with CFR 0.152.
 */
package uk.co.demon.obelisk.xasm;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import uk.co.demon.obelisk.xapp.Application;
import uk.co.demon.obelisk.xasm.FileSource;
import uk.co.demon.obelisk.xasm.Line;
import uk.co.demon.obelisk.xasm.MacroSource;
import uk.co.demon.obelisk.xasm.MemoryModel;
import uk.co.demon.obelisk.xasm.Opcode;
import uk.co.demon.obelisk.xasm.Pass;
import uk.co.demon.obelisk.xasm.RepeatSource;
import uk.co.demon.obelisk.xasm.Source;
import uk.co.demon.obelisk.xasm.TextSource;
import uk.co.demon.obelisk.xasm.Token;
import uk.co.demon.obelisk.xasm.TokenKind;
import uk.co.demon.obelisk.xobj.Expr;
import uk.co.demon.obelisk.xobj.Extern;
import uk.co.demon.obelisk.xobj.Hex;
import uk.co.demon.obelisk.xobj.Module;
import uk.co.demon.obelisk.xobj.Section;
import uk.co.demon.obelisk.xobj.Value;

public abstract class Assembler
extends Application {
    protected static final TokenKind OPERATOR = new TokenKind("OPERATOR");
    protected static final TokenKind SYMBOL = new TokenKind("SYMBOL");
    protected static final TokenKind KEYWORD = new TokenKind("KEYWORD");
    protected static final TokenKind NUMBER = new TokenKind("NUMBER");
    protected static final TokenKind STRING = new TokenKind("STRING");
    protected static final TokenKind UNKNOWN = new TokenKind("UNKNOWN");
    protected final Token WS = new Token(UNKNOWN, "#SPACE");
    protected final Opcode EOL = new Opcode(UNKNOWN, "#EOL"){

        public boolean compile() {
            return true;
        }
    };
    protected final Token ORIGIN = new Token(KEYWORD, "ORIGIN");
    protected final Token COMMA = new Token(KEYWORD, ",");
    protected final Token COLON = new Token(KEYWORD, ":");
    protected final Token PLUS = new Token(OPERATOR, "+");
    protected final Token MINUS = new Token(OPERATOR, "-");
    protected final Token TIMES = new Token(OPERATOR, "*");
    protected final Token DIVIDE = new Token(OPERATOR, "/");
    protected final Token MODULO = new Token(OPERATOR, "%");
    protected final Token COMPLEMENT = new Token(OPERATOR, "~");
    protected final Token BINARYAND = new Token(OPERATOR, "&");
    protected final Token BINARYOR = new Token(OPERATOR, "|");
    protected final Token BINARYXOR = new Token(OPERATOR, "^");
    protected final Token LOGICALNOT = new Token(OPERATOR, "!");
    protected final Token LOGICALAND = new Token(OPERATOR, "&&");
    protected final Token LOGICALOR = new Token(OPERATOR, "||");
    protected final Token EQ = new Token(OPERATOR, "=");
    protected final Token NE = new Token(OPERATOR, "!=");
    protected final Token LT = new Token(OPERATOR, "<");
    protected final Token LE = new Token(OPERATOR, "<=");
    protected final Token GT = new Token(OPERATOR, ">");
    protected final Token GE = new Token(OPERATOR, ">=");
    protected final Token LSHIFT = new Token(OPERATOR, "<<");
    protected final Token RSHIFT = new Token(OPERATOR, ">>");
    protected final Token LPAREN = new Token(OPERATOR, "(");
    protected final Token RPAREN = new Token(OPERATOR, ")");
    protected final Token LO = new Token(KEYWORD, "LO");
    protected final Token HI = new Token(KEYWORD, "HI");
    protected final Token BANK = new Token(KEYWORD, "BANK");
    protected final Token INCLUDE = new Opcode(KEYWORD, ".INCLUDE"){

        public boolean compile() {
            Assembler.this.token = Assembler.this.nextRealToken();
            if (Assembler.this.token.getKind() == STRING) {
                String filename = Assembler.this.token.getText();
                FileReader reader = Assembler.this.findFile(filename, true);
                if (reader != null) {
                    Assembler.this.sources.push(new FileSource(filename, reader));
                } else {
                    Assembler.this.error("Failed to find specified file");
                }
            } else {
                Assembler.this.error("Expected quoted filename");
            }
            return false;
        }
    };
    protected final Token APPEND = new Opcode(KEYWORD, ".APPEND"){

        public boolean compile() {
            if (Assembler.this.token.getKind() == STRING) {
                String filename = Assembler.this.token.getText();
                FileReader reader = Assembler.this.findFile(filename, false);
                if (reader != null) {
                    Assembler.this.sources.pop();
                    Assembler.this.sources.push(new FileSource(filename, reader));
                } else {
                    Assembler.this.error("Failed to find specified file");
                }
            } else {
                Assembler.this.error("Expected quoted filename");
            }
            return false;
        }
    };
    protected final Token INSERT = new Opcode(KEYWORD, ".INSERT"){

        public boolean compile() {
            if (Assembler.this.token.getKind() == STRING) {
                String filename = Assembler.this.token.getText();
                FileReader reader = Assembler.this.findFile(filename, false);
                if (reader != null) {
                    BufferedReader buffer = new BufferedReader(reader);
                    try {
                        int ch;
                        while ((ch = buffer.read()) != -1) {
                            Assembler.this.addByte(ch);
                        }
                        buffer.close();
                    }
                    catch (IOException error) {
                        Assembler.this.error("I/O error while inserting binary data");
                    }
                } else {
                    Assembler.this.error("Failed to find specified file");
                }
            } else {
                Assembler.this.error("Expected quoted filename");
            }
            return false;
        }
    };
    protected final Opcode END = new Opcode(KEYWORD, ".END"){

        public boolean compile() {
            Assembler.this.sources.clear();
            return false;
        }
    };
    protected final Opcode EQU = new Opcode(KEYWORD, ".EQU"){

        public boolean compile() {
            Assembler.this.token = Assembler.this.nextRealToken();
            Assembler.this.addr = Assembler.this.parseExpr();
            if (Assembler.this.pass == Pass.FIRST) {
                if (Assembler.this.label.getText().charAt(0) != '.') {
                    if (!Assembler.this.variable.contains(Assembler.this.label.getText())) {
                        if (!Assembler.this.symbols.containsKey(Assembler.this.label.getText())) {
                            Assembler.this.symbols.put(Assembler.this.label.getText(), Assembler.this.addr);
                        } else {
                            Assembler.this.error("Label as already been defined: ");
                        }
                    } else {
                        Assembler.this.error("Symbol has already been defined with .SET");
                    }
                } else {
                    Assembler.this.error("Equate symbols may not start with a '.'");
                }
            }
            return false;
        }
    };
    protected final Opcode SET = new Opcode(KEYWORD, ".SET"){

        public boolean compile() {
            Assembler.this.token = Assembler.this.nextRealToken();
            Assembler.this.addr = Assembler.this.parseExpr();
            if (Assembler.this.label.getText().charAt(0) != '.') {
                Assembler.this.doSet(Assembler.this.label.getText(), Assembler.this.addr);
            } else {
                Assembler.this.error("Variable symbols may not start with a '.'");
            }
            return false;
        }
    };
    protected final Token SPACE = new Opcode(KEYWORD, ".SPACE"){

        public boolean compile() {
            Assembler.this.token = Assembler.this.nextRealToken();
            Expr expr = Assembler.this.parseExpr();
            if (expr.isAbsolute()) {
                long value = expr.resolve(null, null);
                int index = 0;
                while ((long)index < value) {
                    Assembler.this.addByte(0);
                    ++index;
                }
            } else {
                Assembler.this.error("Constant expression required");
            }
            return true;
        }
    };
    protected final Opcode BYTE = new Opcode(KEYWORD, ".BYTE"){

        public boolean compile() {
            do {
                Assembler.this.token = Assembler.this.nextRealToken();
                if (Assembler.this.token.getKind() == STRING) {
                    String value = Assembler.this.token.getText();
                    int index = 0;
                    while (index < value.length()) {
                        Assembler.this.addByte(value.charAt(index));
                        ++index;
                    }
                    Assembler.this.token = Assembler.this.nextRealToken();
                    continue;
                }
                Expr expr = Assembler.this.parseExpr();
                if (expr != null) {
                    Assembler.this.addByte(expr);
                    continue;
                }
                Assembler.this.error("Invalid expression");
            } while (Assembler.this.token == Assembler.this.COMMA);
            if (Assembler.this.token != Assembler.this.EOL) {
                Assembler.this.error("Invalid expression");
            }
            return true;
        }
    };
    protected final Opcode DBYTE = new Opcode(KEYWORD, ".DBYTE"){

        public boolean compile() {
            do {
                Assembler.this.token = Assembler.this.nextRealToken();
                Expr expr = Assembler.this.parseExpr();
                if (expr != null) {
                    Assembler.this.addByte(Expr.and(Expr.shr(expr, EIGHT), MASK));
                    Assembler.this.addByte(Expr.and(expr, MASK));
                    continue;
                }
                Assembler.this.error("Invalid expression");
            } while (Assembler.this.token == Assembler.this.COMMA);
            if (Assembler.this.token != Assembler.this.EOL) {
                Assembler.this.error("Invalid expression");
            }
            return true;
        }
    };
    protected final Opcode WORD = new Opcode(KEYWORD, ".WORD"){

        public boolean compile() {
            do {
                Assembler.this.token = Assembler.this.nextRealToken();
                Expr expr = Assembler.this.parseExpr();
                if (expr != null) {
                    Assembler.this.addWord(expr);
                    continue;
                }
                Assembler.this.error("Invalid expression");
            } while (Assembler.this.token == Assembler.this.COMMA);
            if (Assembler.this.token != Assembler.this.EOL) {
                Assembler.this.error("Invalid expression");
            }
            return true;
        }
    };
    protected final Opcode LONG = new Opcode(KEYWORD, ".LONG"){

        public boolean compile() {
            do {
                Assembler.this.token = Assembler.this.nextRealToken();
                Expr expr = Assembler.this.parseExpr();
                if (expr != null) {
                    Assembler.this.addLong(expr);
                    continue;
                }
                Assembler.this.error("Invalid expression");
            } while (Assembler.this.token == Assembler.this.COMMA);
            if (Assembler.this.token != Assembler.this.EOL) {
                Assembler.this.error("Invalid expression");
            }
            return true;
        }
    };
    protected final Opcode IF = new Opcode(KEYWORD, ".IF", true){

        public boolean compile() {
            if (Assembler.this.isActive()) {
                Assembler.this.token = Assembler.this.nextRealToken();
                Expr expr = Assembler.this.parseExpr();
                if (expr.isAbsolute()) {
                    boolean state = expr.resolve(null, null) != 0L;
                    Assembler.this.status.push(Assembler.this.isActive() && state ? Boolean.TRUE : Boolean.FALSE);
                } else {
                    Assembler.this.error("Constant expression required");
                }
            } else {
                Assembler.this.status.push(Boolean.FALSE);
            }
            return false;
        }
    };
    protected final Opcode IFABS = new Opcode(KEYWORD, ".IFABS", true){

        public boolean compile() {
            if (Assembler.this.isActive()) {
                Assembler.this.token = Assembler.this.nextRealToken();
                Expr expr = Assembler.this.parseExpr();
                if (expr.isAbsolute()) {
                    Assembler.this.status.push(Boolean.TRUE);
                } else {
                    Assembler.this.status.push(Boolean.FALSE);
                }
            } else {
                Assembler.this.status.push(Boolean.FALSE);
            }
            return false;
        }
    };
    protected final Opcode IFNABS = new Opcode(KEYWORD, ".IFNABS", true){

        public boolean compile() {
            if (Assembler.this.isActive()) {
                Assembler.this.token = Assembler.this.nextRealToken();
                Expr expr = Assembler.this.parseExpr();
                if (expr.isAbsolute()) {
                    Assembler.this.status.push(Boolean.FALSE);
                } else {
                    Assembler.this.status.push(Boolean.TRUE);
                }
            } else {
                Assembler.this.status.push(Boolean.FALSE);
            }
            return false;
        }
    };
    protected final Opcode IFREL = new Opcode(KEYWORD, ".IFREL", true){

        public boolean compile() {
            if (Assembler.this.isActive()) {
                Assembler.this.token = Assembler.this.nextRealToken();
                Expr expr = Assembler.this.parseExpr();
                if (expr.isRelative()) {
                    Assembler.this.status.push(Boolean.TRUE);
                } else {
                    Assembler.this.status.push(Boolean.FALSE);
                }
            } else {
                Assembler.this.status.push(Boolean.FALSE);
            }
            return false;
        }
    };
    protected final Opcode IFNREL = new Opcode(KEYWORD, ".IFNREL", true){

        public boolean compile() {
            if (Assembler.this.isActive()) {
                Assembler.this.token = Assembler.this.nextRealToken();
                Expr expr = Assembler.this.parseExpr();
                if (expr.isRelative()) {
                    Assembler.this.status.push(Boolean.FALSE);
                } else {
                    Assembler.this.status.push(Boolean.TRUE);
                }
            } else {
                Assembler.this.status.push(Boolean.FALSE);
            }
            return false;
        }
    };
    protected final Opcode ELSE = new Opcode(KEYWORD, ".ELSE", true){

        public boolean compile() {
            if (!Assembler.this.status.empty()) {
                boolean state = (Boolean)Assembler.this.status.pop();
                Assembler.this.status.push(Assembler.this.isActive() && !state ? Boolean.TRUE : Boolean.FALSE);
            } else {
                Assembler.this.error(".ELSE or .ENDIF with no matching .IF");
            }
            return false;
        }
    };
    protected final Opcode ENDIF = new Opcode(KEYWORD, ".ENDIF", true){

        public boolean compile() {
            if (!Assembler.this.status.empty()) {
                Assembler.this.status.pop();
            } else {
                Assembler.this.error(".ELSE or .ENDIF with no matching .IF");
            }
            return false;
        }
    };
    protected final Token MACRO = new Opcode(KEYWORD, ".MACRO"){

        public boolean compile() {
            String string = Assembler.this.label.getText();
            Assembler.this.macroName = string;
            if (string != null) {
                Vector<String> arguments = new Vector<String>();
                while ((Assembler.this.token = Assembler.this.nextRealToken()) != Assembler.this.EOL) {
                    if (Assembler.this.token.getKind() != SYMBOL && Assembler.this.token.getKind() != KEYWORD) {
                        Assembler.this.error("Illegal macro argument");
                        break;
                    }
                    arguments.add(Assembler.this.token.getText());
                    Assembler.this.token = Assembler.this.nextRealToken();
                    if (Assembler.this.token == Assembler.this.EOL) break;
                    if (Assembler.this.token == Assembler.this.COMMA) continue;
                    Assembler.this.error("Unexpected token after macro argument");
                    break;
                }
                Assembler.this.savedLines = new MacroSource(arguments);
            }
            return false;
        }
    };
    protected final Token ENDM = new Opcode(KEYWORD, ".ENDM"){

        public boolean compile() {
            Assembler.this.macros.put(Assembler.this.macroName, Assembler.this.savedLines);
            Assembler.this.savedLines = null;
            return false;
        }
    };
    protected final Token EXITM = new Opcode(KEYWORD, ".EXITM"){

        public boolean compile() {
            while (Assembler.this.sources.peek() instanceof MacroSource) {
                Assembler.this.sources.pop();
            }
            return false;
        }
    };
    protected final Token REPEAT = new Opcode(KEYWORD, ".REPEAT"){

        public boolean compile() {
            Assembler.this.token = Assembler.this.nextRealToken();
            Expr expr = Assembler.this.parseExpr();
            if (expr.isAbsolute()) {
                Assembler.this.savedLines = new RepeatSource((int)expr.resolve(null, null));
            } else {
                Assembler.this.error("Constant expression required");
            }
            return false;
        }
    };
    protected final Token ENDR = new Opcode(KEYWORD, ".ENDR"){

        public boolean compile() {
            Assembler.this.sources.push(Assembler.this.savedLines);
            Assembler.this.savedLines = null;
            return false;
        }
    };
    protected final Opcode CODE = new Opcode(KEYWORD, ".CODE"){

        public boolean compile() {
            Assembler.this.section = Assembler.this.code;
            return false;
        }
    };
    protected final Opcode DATA = new Opcode(KEYWORD, ".DATA"){

        public boolean compile() {
            Assembler.this.section = Assembler.this.data;
            return false;
        }
    };
    protected final Opcode BSS = new Opcode(KEYWORD, ".BSS"){

        public boolean compile() {
            Assembler.this.section = Assembler.this.bss;
            return false;
        }
    };
    protected final Opcode ORG = new Opcode(KEYWORD, ".ORG"){

        public boolean compile() {
            Assembler.this.token = Assembler.this.nextRealToken();
            Expr expr = Assembler.this.parseExpr();
            if (expr.isAbsolute()) {
                Assembler.this.section = Assembler.this.section.setOrigin(expr.resolve(null, null));
            } else {
                Assembler.this.error("Constant expression required");
            }
            return true;
        }
    };
    protected final Opcode EXTERN = new Opcode(KEYWORD, ".EXTERN"){

        public boolean compile() {
            if (Assembler.this.pass == Pass.FIRST) {
                do {
                    Assembler.this.token = Assembler.this.nextRealToken();
                    if (Assembler.this.token.getKind() != SYMBOL) {
                        Assembler.this.error("Expected a list of symbols");
                        return false;
                    }
                    String name = Assembler.this.token.getText();
                    Assembler.this.externs.add(name);
                    if (!Assembler.this.symbols.containsKey(name)) {
                        Assembler.this.symbols.put(name, new Extern(name));
                    }
                    Assembler.this.token = Assembler.this.nextRealToken();
                } while (Assembler.this.token == Assembler.this.COMMA);
            }
            return false;
        }
    };
    protected final Opcode GLOBAL = new Opcode(KEYWORD, ".GLOBAL"){

        public boolean compile() {
            if (Assembler.this.pass == Pass.FIRST) {
                do {
                    Assembler.this.token = Assembler.this.nextRealToken();
                    if (Assembler.this.token.getKind() != SYMBOL) {
                        Assembler.this.error("Expected a list of symbols");
                        return false;
                    }
                    String name = Assembler.this.token.getText();
                    Assembler.this.globals.add(name);
                    Assembler.this.token = Assembler.this.nextRealToken();
                } while (Assembler.this.token == Assembler.this.COMMA);
            }
            return false;
        }
    };
    protected final Opcode LIST = new Opcode(KEYWORD, ".LIST"){

        public boolean compile() {
            Assembler.this.listing = true;
            return false;
        }
    };
    protected final Opcode NOLIST = new Opcode(KEYWORD, ".NOLIST"){

        public boolean compile() {
            Assembler.this.listing = false;
            return false;
        }
    };
    protected final Opcode PAGE = new Opcode(KEYWORD, ".PAGE"){

        public boolean compile() {
            Assembler.this.throwPage = true;
            return false;
        }
    };
    protected final Opcode TITLE = new Opcode(KEYWORD, ".TITLE"){

        public boolean compile() {
            Assembler.this.token = Assembler.this.nextRealToken();
            Assembler.this.title = Assembler.this.token.getText();
            return false;
        }
    };
    protected Token token;
    protected char lineType;
    protected Expr addr;
    protected String title;
    protected MemoryModel memory = null;
    private static final Value MASK = new Value(null, 255L);
    private static final Value SIXTEEN = new Value(null, 16L);
    private static final Value EIGHT = new Value(null, 8L);
    private static final Value ZERO = new Value(null, 0L);
    private static StringBuffer buffer = new StringBuffer();
    private int tabSize = 8;
    private boolean listing;
    private int pageCount;
    private int lineCount;
    private int linesPerPage = 60;
    private PrintWriter listFile = null;
    private boolean throwPage;
    private Module module;
    private Section section;
    private Section code;
    private Section data;
    private Section bss;
    private Pass pass;
    private Value origin;
    private String lastLabel;
    private Token label;
    private Stack<Source> sources = new Stack();
    private Stack<Token> tokens = new Stack();
    private Stack<Boolean> status = new Stack();
    private Line line;
    private char[] text;
    private int offset;
    private int errors;
    private int warnings;
    private Hashtable<String, Expr> symbols = new Hashtable();
    private HashSet<String> variable = new HashSet();
    private HashSet<String> globals = new HashSet();
    private HashSet<String> externs = new HashSet();
    private Hashtable<String, TextSource> macros = new Hashtable();
    private String macroName = null;
    private TextSource savedLines = null;
    private int macroDepth = 0;
    private int repeatDepth = 0;
    private int instance = 0;

    protected Assembler(Module module) {
        this.module = module;
    }

    protected void setMemoryModel(MemoryModel memory) {
        this.memory = memory;
    }

    protected void startUp() {
        super.startUp();
        switch (this.getArguments().length) {
            case 0: {
                System.err.println("Error: No source file name provided");
                this.setFinished(true);
                break;
            }
            case 1: {
                break;
            }
            default: {
                System.err.println("Error: Only one source file may be given");
                this.setFinished(true);
            }
        }
    }

    protected String describeArguments() {
        return " <source file>";
    }

    protected void execute() {
        this.assemble(this.getArguments()[0]);
        this.setFinished(true);
    }

    protected void cleanUp() {
        if (this.errors > 0) {
            System.exit(1);
        }
    }

    protected abstract boolean isSupportedPass(Pass var1);

    protected void startPass() {
        this.listing = true;
        this.title = "";
        this.pageCount = 1;
        this.lineCount = 0;
        this.throwPage = false;
        this.code = this.module.findSection(".code");
        this.data = this.module.findSection(".data");
        this.bss = this.module.findSection(".bss");
    }

    protected void endPass() {
    }

    protected abstract String formatListing();

    protected final void process() {
        while (!this.sources.empty()) {
            Line line = this.getNextLine();
            if (line == null) {
                this.sources.pop();
                continue;
            }
            this.process(line);
            if (this.pass != Pass.FINAL) continue;
            this.paginate(String.valueOf(this.formatListing()) + this.expandText());
        }
    }

    protected void addByte(Expr expr) {
        this.memory.addByte(this.module, this.section, expr);
    }

    protected void addWord(Expr expr) {
        this.memory.addWord(this.module, this.section, expr);
    }

    protected void addLong(Expr expr) {
        this.memory.addLong(this.module, this.section, expr);
    }

    protected void addByte(int value) {
        this.memory.addByte(this.module, this.section, value);
    }

    protected void addWord(int value) {
        this.memory.addWord(this.module, this.section, value);
    }

    protected void addLong(int value) {
        this.memory.addLong(this.module, this.section, value);
    }

    protected final void paginate(String text) {
        if (this.listFile != null && this.listing) {
            if (this.lineCount == 0) {
                this.listFile.println();
                this.listFile.println(this.title);
                this.listFile.println();
                this.lineCount += 3;
            }
            this.listFile.println(text);
            if (this.throwPage || ++this.lineCount == this.linesPerPage - 3) {
                this.listFile.print('\f');
                ++this.pageCount;
                this.lineCount = 0;
                this.throwPage = false;
            }
        }
    }

    protected final Module getModule() {
        return this.module;
    }

    protected final Token getLabel() {
        return this.label;
    }

    protected final Line getNextLine() {
        if (this.sources.empty()) {
            return null;
        }
        return this.sources.peek().nextLine();
    }

    protected final Section getSection() {
        return this.section;
    }

    protected final void setSection(Section value) {
        this.section = value;
    }

    protected boolean assemble(String fileName) {
        if (!this.assemble(Pass.FIRST, fileName)) {
            return false;
        }
        if (!this.assemble(Pass.INTERMEDIATE, fileName)) {
            return false;
        }
        if (!this.assemble(Pass.FINAL, fileName)) {
            return false;
        }
        for (String name : this.globals) {
            Expr expr = this.symbols.get(name);
            if (expr != null) {
                this.module.addGlobal(name, expr);
                continue;
            }
            this.error("Undefined global symbol: " + name);
        }
        if (this.errors == 0) {
            try {
                String objectName = this.getObjectFile(fileName);
                this.module.setName(new File(objectName).getName());
                PrintStream stream = new PrintStream(new FileOutputStream(objectName));
                stream.println("<?xml version='1.0'?>" + this.module);
                stream.close();
            }
            catch (Exception error) {
                System.err.println("Error: Could not write object module");
                System.exit(1);
            }
        }
        if (this.lineCount != 0) {
            this.throwPage = true;
            this.paginate("");
        }
        this.paginate("Symbol Table");
        this.paginate("");
        Object[] keys = this.symbols.keySet().toArray();
        Arrays.sort(keys);
        int index = 0;
        while (index < keys.length) {
            String name = (String)keys[index];
            Expr expr = this.symbols.get(name);
            long value = expr.resolve(null, null);
            name = (String.valueOf(name) + "                                ").substring(0, 32);
            if (expr.isAbsolute()) {
                this.paginate(String.valueOf(name) + " " + Hex.toHex(value, 8));
            } else {
                this.paginate(String.valueOf(name) + " " + Hex.toHex(value, 8) + "'");
            }
            ++index;
        }
        if (this.listFile != null) {
            this.listFile.close();
        }
        return this.errors == 0;
    }

    protected void process(Line line) {
        this.lineType = this.sources.peek() instanceof TextSource ? (char)43 : (char)32;
        this.memory.clear();
        this.label = null;
        this.line = line;
        this.text = line.getText().toCharArray();
        this.offset = 0;
        this.origin = this.section != null ? this.section.getOrigin() : null;
        this.addr = this.origin;
        this.token = this.nextToken();
        if (this.token == this.EOL) {
            return;
        }
        if (this.token != this.WS) {
            this.label = this.token;
            if (this.label.getKind() != SYMBOL && this.pass == Pass.FIRST) {
                this.warning("This label is a reserved word");
            }
            if ((this.token = this.nextToken()) == this.COLON) {
                this.token = this.nextToken();
            }
        }
        if (this.token == this.WS) {
            this.token = this.nextRealToken();
        }
        if (this.token == this.EQ) {
            this.token = this.EQU;
        }
        if (this.token instanceof Opcode) {
            Opcode opcode = (Opcode)this.token;
            if (opcode.isAlwaysActive() || this.isActive()) {
                if (this.savedLines != null) {
                    if (this.savedLines instanceof RepeatSource) {
                        if (opcode == this.ENDR && --this.repeatDepth == 0) {
                            opcode.compile();
                            return;
                        }
                        if (opcode == this.REPEAT) {
                            ++this.repeatDepth;
                        }
                    }
                    if (this.savedLines instanceof MacroSource) {
                        if (opcode == this.ENDM && --this.macroDepth == 0) {
                            opcode.compile();
                            return;
                        }
                        if (opcode == this.MACRO) {
                            ++this.macroDepth;
                        }
                    }
                    this.savedLines.addLine(line);
                    return;
                }
                if (opcode == this.MACRO && this.macroDepth++ == 0) {
                    opcode.compile();
                    return;
                }
                if (opcode == this.REPEAT && this.repeatDepth++ == 0) {
                    opcode.compile();
                    return;
                }
                if (opcode == this.EQU || opcode == this.SET) {
                    opcode.compile();
                    this.lineType = (char)61;
                    return;
                }
                if (opcode.compile()) {
                    if (this.memory.getByteCount() > 0) {
                        this.lineType = this.sources.peek() instanceof TextSource ? (char)43 : (char)58;
                    }
                    if (this.label != null) {
                        if (this.origin != null) {
                            if (this.label.getText().charAt(0) == '.') {
                                if (this.lastLabel != null) {
                                    this.setLabel(String.valueOf(this.lastLabel) + this.label.getText(), this.origin);
                                } else {
                                    this.error("A local label must be preceded by normal label");
                                }
                            } else {
                                this.lastLabel = this.label.getText();
                                this.setLabel(this.lastLabel, this.origin);
                            }
                        } else {
                            this.error("No active section");
                        }
                        if (this.lineType == ' ') {
                            this.lineType = (char)58;
                        }
                    }
                } else if (this.label != null) {
                    this.warning("This statement cannot be labelled");
                }
            } else {
                this.lineType = (char)45;
            }
            return;
        }
        if (this.savedLines != null) {
            this.savedLines.addLine(line);
            return;
        }
        MacroSource source = (MacroSource)this.macros.get(this.token.getText());
        if (source != null) {
            int start;
            Vector<String> values = new Vector<String>();
            do {
                start = this.offset;
                this.token = this.nextToken();
            } while (this.token == this.WS);
            while (this.token != this.EOL) {
                int end;
                do {
                    end = this.offset;
                } while ((this.token = this.nextRealToken()) != this.EOL && this.token != this.COMMA);
                values.add(new String(this.text, start, end - start));
                start = this.offset;
            }
            if (this.label != null) {
                if (this.origin != null) {
                    if (this.label.getText().charAt(0) == '.') {
                        if (this.lastLabel != null) {
                            this.setLabel(String.valueOf(this.lastLabel) + this.label.getText(), this.origin);
                        } else {
                            this.error("A local label must be preceded by normal label");
                        }
                    } else {
                        this.lastLabel = this.label.getText();
                        this.setLabel(this.lastLabel, this.origin);
                    }
                } else {
                    this.error("No active section");
                }
            }
            this.sources.push(source.invoke(++this.instance, values));
            return;
        }
        if (this.label != null) {
            if (this.origin != null) {
                if (this.label.getText().charAt(0) == '.') {
                    if (this.lastLabel != null) {
                        this.setLabel(String.valueOf(this.lastLabel) + this.label.getText(), this.origin);
                    } else {
                        this.error("A local label must be preceded by normal label");
                    }
                } else {
                    this.lastLabel = this.label.getText();
                    this.setLabel(this.lastLabel, this.origin);
                }
            } else {
                this.error("No active section");
            }
            if (this.lineType == ' ') {
                this.lineType = (char)58;
            }
        }
        this.error("Unknown opcode or directive");
    }

    protected final Pass getPass() {
        return this.pass;
    }

    protected String getListingFile(String fileName) {
        return String.valueOf(fileName.substring(0, fileName.lastIndexOf(46))) + ".lst";
    }

    protected String getObjectFile(String fileName) {
        return String.valueOf(fileName.substring(0, fileName.lastIndexOf(46))) + ".obj";
    }

    protected boolean isActive() {
        if (this.status.empty()) {
            return true;
        }
        return this.status.peek();
    }

    protected Expr parseExpr() {
        try {
            return this.parseLogical();
        }
        catch (Exception error) {
            this.error("Invalid expression");
            return ZERO;
        }
    }

    protected final Token nextRealToken() {
        Token token = this.nextToken();
        while (token == this.WS) {
            token = this.nextToken();
        }
        return token;
    }

    protected final Token nextToken() {
        if (!this.tokens.empty()) {
            return this.tokens.pop();
        }
        return this.readToken();
    }

    protected abstract Token readToken();

    protected final void pushToken(Token token) {
        this.tokens.push(token);
    }

    protected final char nextChar() {
        char ch = this.peekChar();
        if (ch != '\u0000') {
            ++this.offset;
        }
        return ch;
    }

    protected final char peekChar() {
        return this.offset < this.text.length ? this.text[this.offset] : (char)'\u0000';
    }

    protected void error(String text) {
        String msg = "Error: " + this.line.getFileName() + " (" + this.line.getLineNumber() + ") " + text;
        System.err.println(msg);
        if (this.pass == Pass.FINAL) {
            this.paginate(msg);
        }
        ++this.errors;
    }

    protected void warning(String text) {
        String msg = "Warning: " + this.line.getFileName() + " (" + this.line.getLineNumber() + ") " + text;
        System.err.println(msg);
        if (this.pass == Pass.FINAL) {
            this.paginate(msg);
        }
        ++this.warnings;
    }

    protected final Value getOrigin() {
        return this.origin;
    }

    protected static boolean isSpace(char ch) {
        return ch == ' ' || ch == '\t';
    }

    protected static boolean isBinary(char ch) {
        return ch == '0' || ch == '1';
    }

    protected static boolean isOctal(char ch) {
        return ch >= '0' && ch <= '7';
    }

    protected static boolean isDecimal(char ch) {
        return ch >= '0' && ch <= '9';
    }

    protected static boolean isHexadecimal(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'F' || ch >= 'a' && ch <= 'f';
    }

    protected static boolean isAlpha(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    protected static boolean isAlphanumeric(char ch) {
        return ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z';
    }

    protected void doSet(String label, Expr value) {
        if (this.symbols.containsKey(label)) {
            if (this.variable.contains(label)) {
                this.symbols.put(label, value);
            } else {
                this.error("Symbol has already been defined.");
            }
        } else {
            this.symbols.put(label, value);
            this.variable.add(label);
        }
    }

    private boolean assemble(Pass pass, String fileName) {
        this.pass = pass;
        if (!this.isSupportedPass(this.pass)) {
            return true;
        }
        this.startPass();
        this.module.clear();
        this.errors = 0;
        this.warnings = 0;
        this.section = this.code;
        this.lastLabel = null;
        this.savedLines = null;
        this.repeatDepth = 0;
        this.macroDepth = 0;
        this.instance = 0;
        try {
            if (pass == Pass.FINAL) {
                this.listFile = new PrintWriter(new FileWriter(this.getListingFile(fileName)));
            }
            this.sources.push(new FileSource(fileName, new FileReader(fileName)));
            this.process();
        }
        catch (FileNotFoundException error) {
            System.err.println("Source file not found: " + fileName);
            System.exit(2);
        }
        catch (IOException error) {
            System.err.println("Could not create listing file");
            System.exit(2);
        }
        this.endPass();
        return this.errors == 0;
    }

    private void setLabel(String name, Value value) {
        if (this.pass == Pass.FIRST && this.symbols.containsKey(name)) {
            this.error("Label as already been defined: " + name);
        } else {
            this.symbols.put(name, value);
        }
    }

    private Expr parseLogical() {
        Expr expr = this.parseBinary();
        while (this.token == this.LOGICALAND || this.token == this.LOGICALOR) {
            if (this.token == this.LOGICALAND) {
                this.token = this.nextRealToken();
                expr = Expr.land(expr, this.parseBinary());
                continue;
            }
            this.token = this.nextRealToken();
            expr = Expr.lor(expr, this.parseBinary());
        }
        return expr;
    }

    private Expr parseBinary() {
        Expr expr = this.parseEquality();
        while (this.token == this.BINARYAND || this.token == this.BINARYOR || this.token == this.BINARYXOR) {
            if (this.token == this.BINARYAND) {
                this.token = this.nextRealToken();
                expr = Expr.and(expr, this.parseEquality());
                continue;
            }
            if (this.token == this.BINARYOR) {
                this.token = this.nextRealToken();
                expr = Expr.or(expr, this.parseEquality());
                continue;
            }
            this.token = this.nextRealToken();
            expr = Expr.xor(expr, this.parseEquality());
        }
        return expr;
    }

    private Expr parseEquality() {
        Expr expr = this.parseInequality();
        while (this.token == this.EQ || this.token == this.NE) {
            if (this.token == this.EQ) {
                this.token = this.nextRealToken();
                expr = Expr.eq(expr, this.parseEquality());
                continue;
            }
            this.token = this.nextRealToken();
            expr = Expr.ne(expr, this.parseEquality());
        }
        return expr;
    }

    private Expr parseInequality() {
        Expr expr = this.parseShift();
        while (this.token == this.LT || this.token == this.LE || this.token == this.GT || this.token == this.GE) {
            if (this.token == this.LT) {
                this.token = this.nextRealToken();
                expr = Expr.lt(expr, this.parseShift());
                continue;
            }
            if (this.token == this.LE) {
                this.token = this.nextRealToken();
                expr = Expr.le(expr, this.parseShift());
                continue;
            }
            if (this.token == this.GT) {
                this.token = this.nextRealToken();
                expr = Expr.gt(expr, this.parseShift());
                continue;
            }
            this.token = this.nextRealToken();
            expr = Expr.ge(expr, this.parseShift());
        }
        return expr;
    }

    private Expr parseShift() {
        Expr expr = this.parseAddSub();
        while (this.token == this.RSHIFT || this.token == this.LSHIFT) {
            if (this.token == this.RSHIFT) {
                this.token = this.nextRealToken();
                expr = Expr.shr(expr, this.parseAddSub());
                continue;
            }
            this.token = this.nextRealToken();
            expr = Expr.shl(expr, this.parseAddSub());
        }
        return expr;
    }

    private Expr parseAddSub() {
        Expr expr = this.parseMulDiv();
        while (this.token == this.PLUS || this.token == this.MINUS) {
            if (this.token == this.PLUS) {
                this.token = this.nextRealToken();
                expr = Expr.add(expr, this.parseMulDiv());
                continue;
            }
            this.token = this.nextRealToken();
            expr = Expr.sub(expr, this.parseMulDiv());
        }
        return expr;
    }

    private Expr parseMulDiv() {
        Expr expr = this.parseUnary();
        while (this.token == this.TIMES || this.token == this.DIVIDE || this.token == this.MODULO) {
            if (this.token == this.TIMES) {
                this.token = this.nextRealToken();
                expr = Expr.mul(expr, this.parseUnary());
                continue;
            }
            if (this.token == this.DIVIDE) {
                this.token = this.nextRealToken();
                expr = Expr.div(expr, this.parseUnary());
                continue;
            }
            this.token = this.nextRealToken();
            expr = Expr.mod(expr, this.parseUnary());
        }
        return expr;
    }

    private Expr parseUnary() {
        if (this.token == this.MINUS) {
            this.token = this.nextRealToken();
            return Expr.neg(this.parseValue());
        }
        if (this.token == this.PLUS) {
            this.token = this.nextRealToken();
            return this.parseExpr();
        }
        if (this.token == this.COMPLEMENT) {
            this.token = this.nextRealToken();
            return Expr.cpl(this.parseValue());
        }
        if (this.token == this.LOGICALNOT) {
            this.token = this.nextRealToken();
            return Expr.lnot(this.parseValue());
        }
        if (this.token == this.LO) {
            this.token = this.nextRealToken();
            return Expr.and(this.parseValue(), MASK);
        }
        if (this.token == this.HI) {
            this.token = this.nextRealToken();
            return Expr.and(Expr.shr(this.parseValue(), EIGHT), MASK);
        }
        if (this.token == this.BANK) {
            this.token = this.nextRealToken();
            return Expr.shr(this.parseValue(), SIXTEEN);
        }
        return this.parseValue();
    }

    private Expr parseValue() {
        Expr expr = null;
        if (this.token == this.ORIGIN || this.token == this.TIMES) {
            expr = this.origin;
            this.token = this.nextRealToken();
        } else if (this.token == this.LPAREN) {
            this.token = this.nextRealToken();
            expr = this.parseExpr();
            if (this.token != this.RPAREN) {
                this.error("Closing parenthesis missing in expression");
            } else {
                this.token = this.nextRealToken();
            }
        } else if (this.token.getKind() == NUMBER) {
            expr = new Value(null, ((Integer)this.token.getValue()).intValue());
            this.token = this.nextRealToken();
        } else if (this.token.getKind() == SYMBOL || this.token.getKind() == KEYWORD) {
            if (this.token.getText().charAt(0) == '.') {
                if (this.lastLabel != null) {
                    expr = this.symbols.get(String.valueOf(this.lastLabel) + this.token.getText());
                } else {
                    this.error("A local label must be preceded by normal label");
                }
            } else {
                expr = this.symbols.get(this.token.getText());
            }
            if (expr == null) {
                if (this.pass == Pass.FINAL) {
                    this.error("Undefined symbol: " + this.token.getText());
                }
                expr = ZERO;
            }
            this.token = this.nextRealToken();
        }
        return expr;
    }

    private String expandText() {
        buffer.setLength(0);
        int index = 0;
        while (index < this.text.length) {
            if (this.text[index] == '\t') {
                do {
                    buffer.append(' ');
                } while (buffer.length() % this.tabSize != 0);
            } else {
                buffer.append(this.text[index]);
            }
            ++index;
        }
        return buffer.toString();
    }

    private FileReader findFile(String filename, boolean search) {
        FileReader reader = null;
        try {
            reader = new FileReader(filename);
        }
        catch (FileNotFoundException error) {
            if (search) {
                // empty if block
            }
            this.error("Could not find the specified file");
        }
        return reader;
    }
}

